 ; Ŀ
 ;   Clime - subroutine - climb a directory tree and find a file to load.  
 ;   Copyright 2006, 2010 by Rocket Software Ltd.                          
 ;   Refa.lsp has this internally.                                         
 ;   If Clime loads and runs a file which returns nil then it reports      
 ;   an error, so files which are to be run should have (princ) as the     
 ;   last line.                                                            
 ; 

 ; Ŀ
 ;   Climb - find a file by climbing the directory tree.                   
 ;   Arguments: Fnam, a file name without path.                            
 ;              Path, if true and the file isn't found in the local tree,  
 ;              do a findfile search for it, i.e. the entire acad path.    
 ;   Calls Dstep.                                                          
 ;   Returns a filename with path string or nil.                           
 ; 
 (DEFUN CLIMB (fnam path / prefa fila)
 ; Ŀ
 ;   Find out where we are, windows being unclear on the concept.          
 ; 
  (setq prefa (getvar "dwgprefix"))
 ; Ŀ
 ;   Step up until find the file or run out of path.                       
 ; 
  (while (and (/= prefa "")
              (not (setq fila (findfile (strcat prefa fnam)))))
         (setq prefa (dstep prefa)))
 ; Ŀ
 ;   If the file wasn't in the current tree, search the whole acad path.   
 ; 
  (if (and (null fila) path)
      (setq fila (findfile fnam)))
 fila)
 ; Ŀ
 ;   Climb end.                                                            
 ; 

 ; Ŀ
 ;   Dstep - remove the last level from a path.                            
 ;   Arguments: Stra, a path string.                                       
 ;   Returns a truncated path or "".                                       
 ; 
 (DEFUN DSTEP (stra / pos)
 ; Ŀ
 ;   The last character will probably be a backslash, therefore remove     
 ;   it so that it doesn't stop the loop.                                  
 ; 
  (setq pos (strlen stra))
  (if (and (/= pos 0)
           (member (substr stra pos 1) '("/" "\\")))
      (setq stra (substr stra 1 (1- pos))))
 ; Ŀ
 ;   Remove the next step.                                                 
 ; 
  (setq pos (strlen stra))
  (while (and (/= pos 0)
              (not (member (substr stra pos 1) '("/" "\\"))))
         (setq pos (1- pos)))
  (setq stra (substr stra 1 pos))
 stra)
 ; Ŀ
 ;   Dstep end.                                                            
 ; 

 ; Ŀ
 ;   Clime - load, check, and optionally run a lisp file.                  
 ;   Searches up from the current directory, stopping at the local root.   
 ;   Otherwise loads whichever copy is first in the acad search path.      
 ;   Arguments: Name  - The routine to load.                               
 ;              Find  - if true, find in the search path if couldn't       
 ;                      find the file by climbing.                         
 ;              Run   - Run the routine if this isn't nil.                 
 ; 
 (DEFUN CLIME (name find run / fina)
  (if (and (print (setq fina (climb name find)))
           (load fina ()))
      (if run (eval (read (strcat "(c:" name ")"))))
      (write-line (strcat "** Clime Error: Can't load " name ". **\n")))
 (princ))